<?php
function huntor_child_theme_enqueue_styles() {
    // Enqueue parent style first
    wp_enqueue_style('huntor-parent-style', 
        get_template_directory_uri() . '/style.css'
    );
    
    // Enqueue child style after parent
    wp_enqueue_style('huntor-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array('huntor-parent-style'),
        wp_get_theme()->get('Version')
    );
}
// Use a lower priority number than 20 to ensure it runs before the parent theme's add_scripts
add_action('wp_enqueue_scripts', 'huntor_child_theme_enqueue_styles', 5);

// Add this function to ensure parent theme customizer settings are applied
function huntor_child_theme_setup() {
    // Make sure the child theme supports customizer features
    add_theme_support('customize-selective-refresh-widgets');
    add_theme_support('opal-customize-css');
}
add_action('after_setup_theme', 'huntor_child_theme_setup', 11);

// Remove the huntor_child_custom_css function that might be interfering
// with the parent theme's CSS generation
function huntor_child_disable_custom_css() {
    // Remove our custom CSS handler that might be interfering
    remove_action('wp_head', 'huntor_child_custom_css', 100);
}
add_action('init', 'huntor_child_disable_custom_css');


// <?php
// function huntor_child_theme_enqueue_styles() {
//     $parent_style = 'huntor-style';
//     $parent_theme = wp_get_theme('huntor');
//     $parent_version = $parent_theme->get('Version');

//     // Parent's main style
//     wp_enqueue_style($parent_style, 
//         get_template_directory_uri() . '/style.css'
//     );

//     // Essential parent theme styles
//     wp_enqueue_style('huntor-opal-icon', 
//         get_template_directory_uri() . '/assets/css/opal-icons.css'
//     );

//     wp_enqueue_style('opal-boostrap', 
//         get_template_directory_uri() . '/assets/css/opal-boostrap.css'
//     );

//     wp_enqueue_style('huntor-carousel', 
//         get_template_directory_uri() . '/assets/css/carousel.css'
//     );

//     wp_enqueue_style('huntor-customfont', 
//         get_template_directory_uri() . '/assets/css/customfont.css'
//     );

//     // Colors must be loaded before WooCommerce styles
//     if (!class_exists('OSF_Scripts')) {
//         wp_enqueue_style('huntor-colors', 
//             get_template_directory_uri() . '/assets/css/color.css'
//         );
//     }

//     // WooCommerce styles if active
//     if (function_exists('huntor_is_woocommerce_activated') && huntor_is_woocommerce_activated()) {
//         wp_enqueue_style('huntor-woocommerce', 
//             get_template_directory_uri() . '/assets/css/woocommerce.css'
//         );
//     }

//     // Child theme style
//     wp_enqueue_style('huntor-child-style',
//         get_stylesheet_directory_uri() . '/style.css',
//         array($parent_style),
//         wp_get_theme()->get('Version')
//     );

//     // Add customizer colors
//     add_action('wp_head', 'huntor_child_custom_css', 100);
// }
// add_action('wp_enqueue_scripts', 'huntor_child_theme_enqueue_styles', 20);

// function huntor_child_custom_css() {
//     if (function_exists('huntor_custom_css')) {
//         $custom_css = huntor_custom_css();
//         if (!empty($custom_css)) {
//             echo '<style type="text/css">' . wp_strip_all_tags($custom_css) . '</style>';
//         }
//     }
// }


