// jQuery(document).ready(function ($) {
//     $('#billing_phone').on('blur', function () {
//         const phoneInput = $(this).val();
//         const phoneRegex = /^\d{10}$/;

//         // Remove any existing error message
//         $('.phone-error').remove();

//         if (!phoneRegex.test(phoneInput)) {
//             // Add an error message after the input field
//             $(this).after(`<span class="phone-error" style="color: red;">${phoneValidation.errorMessage}</span>`);
//         }
//     });
// });

jQuery(document).ready(function ($) {
    const phoneInputSelector = '#billing_phone';
    const placeOrderButtonSelector = '#place_order';
    const phoneRegex = /^\d{10}$/;

    // Validate phone number on focus out
    $(phoneInputSelector).on('blur', function () {
        const phoneInput = $(this).val();

        // Remove any existing error message
        $('.phone-error').remove();

        if (!phoneRegex.test(phoneInput)) {
            // Add an error message
            $(this).after('<span class="phone-error" style="color: red;">Please enter a valid 10-digit phone number.</span>');
            $(placeOrderButtonSelector).prop('disabled', true); // Disable place order button
        } else {
            $(placeOrderButtonSelector).prop('disabled', false); // Enable place order button
        }
    });

    // Validate phone number on place order button click
    $(placeOrderButtonSelector).on('click', function (e) {
        const phoneInput = $(phoneInputSelector).val();

        // Remove any existing error message
        $('.phone-error').remove();

        if (!phoneRegex.test(phoneInput)) {
            e.preventDefault(); // Prevent form submission
            $(phoneInputSelector).after('<span class="phone-error" style="color: red;">Please enter a valid 10-digit phone number.</span>');
            alert('Please fix the phone number before placing your order.');
        }
    });
});